/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.export.ImageExporter;
import io.github.mortuusars.exposure.client.gui.Widgets;
import io.github.mortuusars.exposure.client.gui.component.SteppedZoom;
import io.github.mortuusars.exposure.client.gui.screen.element.Pager;
import io.github.mortuusars.exposure.client.image.modifier.ImageModifier;
import io.github.mortuusars.exposure.client.input.Key;
import io.github.mortuusars.exposure.client.input.KeyBinding;
import io.github.mortuusars.exposure.client.input.KeyBindings;
import io.github.mortuusars.exposure.client.render.photograph.PhotographStyle;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import io.github.mortuusars.exposure.world.photograph.PhotographType;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class PhotographScreen
extends class_437 {
    protected final Pager pager = new Pager().setCycled(true).setChangeSound(new SoundEffect(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK)).onPageChanged(this::pageChanged);
    protected final SteppedZoom zoom = new SteppedZoom().zoomInSteps(4).zoomOutSteps(4).zoomPerStep(1.4).defaultZoom(1.0);
    protected final KeyBindings keyBindings;
    protected final PhotographProvider photographProvider;
    protected float x;
    protected float y;
    protected final Set<String> savedExposureIds;
    protected final Map<String, File> savedExposureFiles;
    protected ArrayList<ItemAndStack<PhotographItem>> photographs;

    public PhotographScreen(PhotographProvider photographProvider) {
        super((class_2561)class_2561.method_43473());
        KeyBinding[] keyBindingArray = new KeyBinding[11];
        keyBindingArray[0] = Key.press(Minecrft.options().field_1822).executes(() -> ((PhotographScreen)this).method_25419());
        keyBindingArray[1] = Key.press(334).or(Key.press(61)).executes(this.zoom::zoomIn);
        keyBindingArray[2] = Key.press(333).or(Key.press(45)).executes(this.zoom::zoomOut);
        keyBindingArray[3] = Key.press(2, 73).executes(this::dropAsItem);
        keyBindingArray[4] = Key.press(2, 67).executes(this::copyIdentifierToClipboard);
        keyBindingArray[5] = Key.press(3, 67).executes(this::copySavedFilePathToClipboard);
        keyBindingArray[6] = Key.press(2, 83).executes(this::openSavedFile);
        keyBindingArray[7] = Key.press(263).or(Key.press(65)).executes(this.pager::previousPage);
        keyBindingArray[8] = Key.press(262).or(Key.press(68)).executes(this.pager::nextPage);
        keyBindingArray[9] = Key.release(263).or(Key.press(65)).executes(this.pager::resetCooldown);
        keyBindingArray[10] = Key.release(262).or(Key.press(68)).executes(this.pager::resetCooldown);
        this.keyBindings = KeyBindings.of(keyBindingArray);
        this.savedExposureIds = new HashSet<String>();
        this.savedExposureFiles = new HashMap<String, File>();
        this.photographs = new ArrayList();
        this.photographProvider = photographProvider;
        this.setPhotographs(photographProvider.get());
        if (this.shouldQueryAllPhotographsImmediately()) {
            this.queryAllPhotographs(this.photographs);
        }
    }

    public PhotographScreen(List<ItemAndStack<PhotographItem>> photographs) {
        this(PhotographProvider.fixed(photographs));
    }

    protected void setPhotographs(List<ItemAndStack<PhotographItem>> photographs) {
        this.photographs.clear();
        this.photographs.addAll(photographs);
        this.pager.setPagesCount(photographs.size());
        this.pager.setPage(0);
    }

    public void method_25393() {
        if (this.photographProvider.shouldRefresh()) {
            this.setPhotographs(this.photographProvider.get());
        }
    }

    protected void method_25426() {
        super.method_25426();
        class_344 previousButton = new class_344(0, (int)((float)this.field_22790 / 2.0f - 8.0f), 16, 16, Widgets.PREVIOUS_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.PREVIOUS), (class_2561)class_2561.method_43471((String)"gui.exposure.previous_page"));
        this.method_37063((class_364)previousButton);
        class_344 nextButton = new class_344(this.field_22789 - 16, (int)((float)this.field_22790 / 2.0f - 8.0f), 16, 16, Widgets.NEXT_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.NEXT), (class_2561)class_2561.method_43471((String)"gui.exposure.next_page"));
        this.method_37063((class_364)nextButton);
        this.pager.setPreviousPageButton((class_4264)previousButton).setNextPageButton((class_4264)nextButton);
    }

    protected boolean shouldQueryAllPhotographsImmediately() {
        return true;
    }

    protected void queryAllPhotographs(List<ItemAndStack<PhotographItem>> photographs) {
        for (ItemAndStack<PhotographItem> photograph : photographs) {
            photograph.getItem().getFrame(photograph.getItemStack()).identifier().ifId(id -> ExposureClient.exposureStore().getOrRequest((String)id));
        }
    }

    public ItemAndStack<PhotographItem> getCurrentPhotograph() {
        return this.photographs.getFirst();
    }

    protected void pageChanged(int oldPage, int newPage) {
        int distance = newPage - oldPage;
        Collections.rotate(this.photographs, -distance);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        float zoomFactor = (float)this.field_22790 * 0.8f;
        float scale = (float)(this.zoom.get() * (double)zoomFactor);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        this.method_52752(guiGraphics);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(this.x, this.y, 0.0f);
        guiGraphics.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 50.0f);
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_51448().method_22904(-0.5, -0.5, 0.0);
        class_4597.class_4598 bufferSource = Minecrft.get().method_22940().method_23000();
        ExposureClient.photographRenderer().renderStackedPhotographs(this.photographs, guiGraphics.method_51448(), (class_4597)bufferSource, 0xF000F0, 255, 255, 255, 255);
        bufferSource.method_22993();
        guiGraphics.method_51448().method_22909();
        ItemAndStack<PhotographItem> photograph = this.getCurrentPhotograph();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.renderFrameInfoHint(guiGraphics, mouseX, mouseY, photograph);
        guiGraphics.method_51448().method_22909();
        if (((Boolean)Config.Client.EXPORT_PHOTOGRAPH_WHEN_VIEWED.get()).booleanValue()) {
            this.trySaveToFile(photograph);
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    private void renderFrameInfoHint(@NotNull class_332 guiGraphics, int mouseX, int mouseY, ItemAndStack<PhotographItem> photograph) {
        if (Minecrft.get().field_1724 == null || !Minecrft.get().field_1724.method_7337()) {
            return;
        }
        Frame frame = photograph.getItem().getFrame(photograph.getItemStack());
        if (frame == Frame.EMPTY) {
            return;
        }
        guiGraphics.method_25303(this.field_22793, "?", this.field_22789 - this.field_22793.method_1727("?") - 10, 10, -1);
        if (mouseX > this.field_22789 - 20 && mouseX < this.field_22789 && mouseY < 20) {
            String exposureName = frame.identifier().map(id -> id, class_2960::toString);
            ArrayList<class_5250> lines = new ArrayList<class_5250>();
            lines.add(class_2561.method_43470((String)exposureName));
            lines.add(class_2561.method_43469((String)"gui.exposure.photograph_screen.drop_as_item_tooltip", (Object[])new Object[]{class_2561.method_43470((String)"CTRL + I")}));
            lines.add(class_2561.method_43469((String)("gui.exposure.photograph_screen.copy_" + frame.identifier().map(id -> "id", texture -> "texture_path") + "_tooltip"), (Object[])new Object[]{"CTRL + C"}));
            frame.identifier().getId().ifPresent(id -> {
                if (this.savedExposureFiles.containsKey(id)) {
                    lines.add(class_2561.method_43469((String)"gui.exposure.photograph_screen.copy_saved_file_path_tooltip", (Object[])new Object[]{class_2561.method_43470((String)"CTRL + SHIFT + C")}));
                    lines.add(class_2561.method_43469((String)"gui.exposure.photograph_screen.open_saved_file_tooltip", (Object[])new Object[]{class_2561.method_43470((String)"CTRL + S")}));
                }
            });
            guiGraphics.method_51437(this.field_22793, lines, Optional.empty(), mouseX, mouseY + 20);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.keyBindings.keyPressed(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.keyBindings.keyReleased(keyCode, scanCode, modifiers) || super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        if (scrollY >= 0.0) {
            this.zoom.zoomIn();
        } else {
            this.zoom.zoomOut();
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.method_25403(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (button == 0) {
            float centerX = (float)this.field_22789 / 2.0f;
            float centerY = (float)this.field_22790 / 2.0f;
            this.x = (float)class_3532.method_15350((double)((double)this.x + dragX), (double)(-centerX), (double)centerX);
            this.y = (float)class_3532.method_15350((double)((double)this.y + dragY), (double)(-centerY), (double)centerY);
            return true;
        }
        return false;
    }

    public boolean method_25421() {
        return false;
    }

    protected boolean dropAsItem() {
        class_1799 droppedStack = this.getCurrentPhotograph().getItemStack().method_7972();
        Minecrft.gameMode().method_2915(droppedStack);
        Minecrft.player().method_7353((class_2561)class_2561.method_43469((String)"gui.exposure.photograph_screen.item_dropped_message", (Object[])new Object[]{droppedStack.method_7954()}), false);
        return true;
    }

    protected boolean copyIdentifierToClipboard() {
        Frame frame = this.getCurrentPhotograph().map(PhotographItem::getFrame);
        if (!Minecrft.player().method_7337() || frame.equals(Frame.EMPTY)) {
            return false;
        }
        String text = frame.identifier().map(id -> id, class_2960::toString);
        Minecrft.get().field_1774.method_1455(text);
        Minecrft.player().method_7353((class_2561)class_2561.method_43469((String)"gui.exposure.photograph_screen.copied_message", (Object[])new Object[]{text}), false);
        return true;
    }

    protected boolean copySavedFilePathToClipboard() {
        return this.getCurrentPhotograph().map(PhotographItem::getFrame).identifier().mapId(id -> {
            File patt0$temp = this.savedExposureFiles.get(id);
            if (patt0$temp instanceof File) {
                File file = patt0$temp;
                Minecrft.get().field_1774.method_1455(file.getAbsolutePath());
                Minecrft.player().method_7353((class_2561)class_2561.method_43469((String)"gui.exposure.photograph_screen.copied_message", (Object[])new Object[]{file.getAbsolutePath()}), false);
                return true;
            }
            return false;
        }).orElse(false);
    }

    protected boolean openSavedFile() {
        return this.getCurrentPhotograph().map(PhotographItem::getFrame).identifier().mapId(id -> {
            File patt0$temp = this.savedExposureFiles.get(id);
            if (patt0$temp instanceof File) {
                File file = patt0$temp;
                class_156.method_668().method_672(file);
                return true;
            }
            return false;
        }).orElse(false);
    }

    protected void trySaveToFile(ItemAndStack<PhotographItem> photograph) {
        Frame frame = photograph.getItem().getFrame(photograph.getItemStack());
        if (frame == Frame.EMPTY || !frame.identifier().isId() || !frame.isTakenBy((class_1309)Minecrft.player())) {
            return;
        }
        String id = frame.identifier().getId().orElseThrow();
        PhotographType photographType = photograph.getItem().getType(photograph.getItemStack());
        PhotographStyle photographStyle = PhotographStyle.of(photograph.getItemStack());
        String filename = this.getFilename(id, photographType);
        if (this.savedExposureIds.contains(filename)) {
            return;
        }
        ExposureClient.exposureStore().getOrRequest(id).getData().ifPresent(exposure -> {
            this.savedExposureIds.add(filename);
            CompletableFuture.runAsync(() -> new ImageExporter((ExposureData)((Object)exposure), filename).modify(ImageModifier.chain(photographStyle.modifier(), ImageModifier.Resize.multiplier((Integer)Config.Client.EXPORT_SIZE_MULTIPLIER.get()))).toExposuresFolder().organizeByWorld((Boolean)Config.Client.EXPORT_ORGANIZE_BY_WORLD.get()).setCreationDate(exposure.getTag().unixTimestamp()).onExport(file -> this.savedExposureFiles.put(id, (File)file)).export()).handle((unused, throwable) -> {
                Exposure.LOGGER.error(throwable.getMessage());
                return null;
            });
        });
    }

    @NotNull
    protected String getFilename(String id, PhotographType photographType) {
        String suffix = photographType.getFileSuffix();
        if (!class_3544.method_15438((String)suffix)) {
            return id + "_" + suffix;
        }
        return id;
    }

    public static interface PhotographProvider {
        public boolean shouldRefresh();

        public List<ItemAndStack<PhotographItem>> get();

        public static PhotographProvider fixed(final List<ItemAndStack<PhotographItem>> photographs) {
            Preconditions.checkState((!photographs.isEmpty() ? 1 : 0) != 0, (Object)"No photographs to display.");
            return new PhotographProvider(){
                private final List<ItemAndStack<PhotographItem>> list;
                {
                    this.list = photographs;
                }

                @Override
                public boolean shouldRefresh() {
                    return false;
                }

                @Override
                public List<ItemAndStack<PhotographItem>> get() {
                    return this.list;
                }
            };
        }

        public static PhotographProvider fromPhotographItem(int slot) {
            return new ItemProvider(() -> Minecrft.player().method_31548().method_5438(slot));
        }

        public static class ItemProvider
        implements PhotographProvider {
            protected Supplier<class_1799> itemSupplier;
            protected List<ItemAndStack<PhotographItem>> photographs;

            public ItemProvider(Supplier<class_1799> itemSupplier) {
                this.itemSupplier = itemSupplier;
                class_1799 stack = itemSupplier.get();
                Preconditions.checkState((stack.method_7909() instanceof PhotographItem || stack.method_7909() instanceof StackedPhotographsItem ? 1 : 0) != 0, (Object)"itemSupplier should supply valid Photograph or Stacked Photographs item stack at the moment of creation.");
                this.photographs = this.fromItemStack(stack);
            }

            protected List<ItemAndStack<PhotographItem>> fromItemStack(class_1799 stack) {
                if (stack.method_7909() instanceof PhotographItem) {
                    return List.of(new ItemAndStack(stack));
                }
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof StackedPhotographsItem) {
                    StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)class_17922;
                    return stackedPhotographsItem.getPhotographs(stack);
                }
                return Collections.emptyList();
            }

            @Override
            public boolean shouldRefresh() {
                boolean shouldRefresh;
                class_1799 item = this.itemSupplier.get();
                List<ItemAndStack<PhotographItem>> newPhotographs = this.fromItemStack(item);
                if (newPhotographs.isEmpty()) {
                    return false;
                }
                boolean bl = shouldRefresh = !this.get().equals(newPhotographs);
                if (shouldRefresh) {
                    this.photographs = newPhotographs;
                }
                return shouldRefresh;
            }

            @Override
            public List<ItemAndStack<PhotographItem>> get() {
                return this.photographs;
            }
        }
    }
}

